const { assert } = require('chai');
const RSAKeyError = require('../src/error');

describe('RSAKeyError', function() {

  let err;
  const MESSAGE = 'this is a test error message';
  const ORIGINAL_MESSAGE = 'original err msg';
  const CODE = 'CUSTOM_ERROR_CODE';

  it('should crate an object', function() {
    err = new RSAKeyError(MESSAGE, CODE);
    assert.instanceOf(err, RSAKeyError);
  });

  it('should have correct message', function() {
    assert(err.message, MESSAGE);
  });

  it('should have correct code', function() {
    assert(err.code, CODE);
  });

  it('should create an object based on another error', function() {
    err = new RSAKeyError(MESSAGE, new Error(ORIGINAL_MESSAGE));
    assert.instanceOf(err, RSAKeyError);
  });

  it('its message should include original message', function() {
    assert.include(err.message, ORIGINAL_MESSAGE);
  });

  it('should include original error object', function() {
    assert.instanceOf(err.originalError, Error);
  });

});