/**
 * @private
 */
class RSAKeyError extends Error {

  /**
   * @param {string} message
   * @param {string} [code]
   * @param {Error} [original]
   */
  constructor(message, code = 'RSA_KEY_ERROR', original) {

    /* Allow skipping code */
    if (typeof original === 'undefined' && typeof code === 'object') {
      original = code;
      code = undefined;
    }

    /* If original error was supplied, include its message in our message */
    let addonMessage = '';
    if (typeof original === 'object' && typeof original.message === 'string') {
      addonMessage = `: ${original.message}`;
    }

    super(message + addonMessage);
    this.code = code;
    this.originalError = original;

    /* Get rid of ourselves from the stack trace */
    Error.captureStackTrace(this, RSAKeyError);

  }

}

module.exports = RSAKeyError;