const jwt = require('jsonwebtoken');
const fs = require('fs');
const rsaKey = require('rsa-key');
const uuidv1 = require('uuid/v1');

var aud = 'KnoxWSM';

var signOptions = {
	audience: aud,
	expiresIn: "30m",
	algorithm: "RS512"
};

exports.printMsg = function() {
  console.log("This is a message from the demo package");
}

exports.generateSignedClientIdentifierJWT = function(certificateFileName, clientIdentifier) {

 signOptions['jwtid'] = uuidv1() + uuidv1();

 let certificate = JSON.parse(fs.readFileSync(certificateFileName, 'utf8'));
 let privateKey = new rsaKey(certificate.Private).exportKey();
 let publicKey_der = new rsaKey(certificate.Public).exportKey('public', 'der');
 let publicKey = Buffer.from(publicKey_der, 'binary').toString('base64');
 
 var payload = {};

 payload['clientIdentifier'] = clientIdentifier;
 payload['publicKey'] = publicKey;

 var token = jwt.sign(payload, privateKey, signOptions);

 payload = {};

 return token;
}

exports.generateSignedAccessTokenJWT = function(certificateFileName, accessToken) {

  signOptions['jwtid'] = uuidv1() + uuidv1();

 let certificate = JSON.parse(fs.readFileSync(certificateFileName, 'utf8')); 
 let privateKey = new rsaKey(certificate.Private).exportKey(); 
 let publicKey_der = new rsaKey(certificate.Public).exportKey('public', 'der'); 
 let publicKey = Buffer.from(publicKey_der, 'binary').toString('base64');
 
 var payload = {}; 

 payload['accessToken'] = accessToken;
 payload['publicKey'] = publicKey;
 var token = jwt.sign(payload, privateKey, signOptions);

 payload = {};

 return token;
}


exports.generateBase64EncodedStringPublicKey = function(certificateFileName) {
 let certificate = JSON.parse(fs.readFileSync(certificateFileName, 'utf8'));
 let publicKey_der = new rsaKey(certificate.Public).exportKey('public', 'der'); 
 let publicKey = Buffer.from(publicKey_der, 'binary').toString('base64');
 
 return publicKey;
}

